# number of rabbits
N0 = 1000
# initially all rabbits start at the origin
x = rep(0,N0)
# number of timesteps
n = 100

# loop over timesteps
for ( i in 1:n )
  {
  # use the binomial distribution to decide which rabbits
  # will step right
  do_jump_right = (rbinom(N0,1,0.5)==1)
  # jump right
  x[do_jump_right] = x[do_jump_right] + 1
  # jump left
  x[!do_jump_right] = x[!do_jump_right] - 1
  }

# draw a histogram of the final rabbit distribution
hist(x,breaks=seq(min(x)-1,max(x)+1,2),ylab='N(x)') 
